/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.SIDMixer;
import com.dreamfabric.jsidplay.PSID;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;

public class PSIDCanvas
extends JComponent {
    private static final int CUTOFF_SIZE = 81;
    private static final int RESONANCE_SIZE = 81;
    private static final int SAMPLE_SIZE = 110;
    private int[] cutoffBuffer = new int[81];
    private int[] resonanceBuffer = new int[81];
    private int[] sampleBuffer = new int[110];
    private int cutoffPos;
    private int resonancePos;
    private static final Color PENCOLOR = new Color(49152);
    private static final Color BORDERCOLOR = new Color(0x204020);
    private SIDMixer mixer;
    PSID psid;

    public PSIDCanvas(PSID psid, SIDMixer mix) {
        this.psid = psid;
        this.mixer = mix;
        this.setFont(new Font("Monospaced", 0, 10));
        this.setForeground(Color.green);
        this.setBackground(Color.black);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(282, 80);
    }

    public void updateFilter(int cutoff, int resonance) {
        this.cutoffBuffer[this.cutoffPos] = cutoff >> 5;
        this.cutoffPos = (this.cutoffPos + 1) % 81;
        this.resonanceBuffer[this.resonancePos] = resonance << 2;
        this.resonancePos = (this.resonancePos + 1) % 81;
    }

    @Override
    public void paintComponent(Graphics g) {
        int ix;
        int i;
        int n;
        boolean quiet = true;
        int height = this.getHeight();
        if (this.psid.lastPlayedSample < 4) {
            quiet = false;
            int playPos = this.psid.playSamplePos;
            if (playPos + 880 > this.psid.sampleEnd && (playPos = this.psid.sampleEnd - 880) < 0) {
                playPos = 0;
            }
            n = 110;
            for (i = 0; i < n; ++i) {
                this.sampleBuffer[i] = this.psid.buffer[(i << 3) + playPos];
            }
        }
        g.setColor(PENCOLOR);
        g.drawString("Sample Output", 6, 10);
        if (!quiet) {
            int n2 = 109;
            for (int i2 = 0; i2 < n2; ++i2) {
                g.drawLine(i2, height - 10 - height * (this.sampleBuffer[i2] >> 1) / 128, i2 + 1, height - 10 - height * (this.sampleBuffer[i2 + 1] >> 1) / 128);
            }
        }
        int pos = 115;
        g.drawString("Flt.Cutoff", pos, 10);
        n = 80;
        for (i = 0; i < n; ++i) {
            ix = (this.cutoffPos + i + 81) % 81;
            g.drawLine(pos + i, height - 10 - height * this.cutoffBuffer[ix] / 128, i + pos + 1, height - 10 - height * this.cutoffBuffer[(ix + 1) % 81] / 128);
        }
        g.drawString("Flt.Res.", pos += 86, 10);
        n = 80;
        for (i = 0; i < n; ++i) {
            ix = (this.resonancePos + i + 81) % 81;
            g.drawLine(pos + i, height - 10 - height * this.resonanceBuffer[ix] / 128, i + pos + 1, height - 10 - height * this.resonanceBuffer[(ix + 1) % 81] / 128);
        }
    }
}

